/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchMaintenance;
import gregtech.api.metatileentity.implementations.MTEHatchMuffler;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.material.MaterialsElements;
import gtPlusPlus.core.material.nuclear.MaterialsNuclides;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTENuclearReactor
extends GTPPMultiBlockBase<MTENuclearReactor>
implements ISurvivalConstructable {
    protected int mFuelRemaining = 0;
    private int mCasing;
    private static IStructureDefinition<MTENuclearReactor> STRUCTURE_DEFINITION = null;

    public MTENuclearReactor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTENuclearReactor(String aName) {
        super(aName);
    }

    @Override
    public long maxEUStore() {
        return 640000000L * (long)Math.min(16, this.mEnergyHatches.size()) / 16L;
    }

    @Override
    public String getMachineType() {
        return "Reactor";
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.liquidFluorineThoriumReactorRecipes;
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    public boolean showRecipeTextInGUI() {
        return false;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Liquid Fluoride Thorium Reactor").addInfo("Produces energy and new elements from Radioactive Beta Decay!").addInfo("Input LFTB and a molten salt as fuel, and match the 4 Buffered Dynamo Hatches:").addInfo("LFTR Fuel 1 (4 EV Hatches), LFTR Fuel 2 (4 IV Hatches), LFTR Fuel 3 (4 LuV Hatches)").addInfo("If using better hatches for a worse fuel, only 1 hatch will output EU").addInfo("Outputs U233 every 10 seconds, on average, while the reactor is running").addInfo("Check NEI to see the other 3 outputs - they differ between fuels").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(7, 4, 7, true).addController("Bottom Center").addCasingInfoMin("Hastelloy-N Reactor Casing", 27, false).addCasingInfoMin("Reactor Shield Casing", 26, false).addInputHatch("Top or bottom layer edges", 1).addOutputHatch("Top or bottom layer edges", 1).addDynamoHatch("Top or bottom layer edges", 1).addMufflerHatch("Top 3x3", 2).addStructureInfo("All dynamos must be between EV and LuV tier.").addStructureInfo("All other hatches must be IV+ tier.").addStructureInfo("4x Output Hatches or 1x Output Hatch (ME), 1+ Input Hatches").addStructureInfo("4x Dynamo Hatches, 4x Mufflers").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public String[] getExtraInfoData() {
        String tRunning = this.mMaxProgresstime > 0 ? "Reactor running" : "Reactor stopped";
        String tMaintainance = this.getIdealStatus() == this.getRepairStatus() ? "No Maintainance issues" : "Needs Maintainance";
        return new String[]{"Liquid Fluoride Thorium Reactor", tRunning, tMaintainance, "Current Output: " + this.lEUt + " EU/t", "Fuel Remaining: " + this.mFuelRemaining + " Litres", "Current Efficiency: " + this.mEfficiency / 5 + "%", "Current Efficiency (Raw): " + this.mEfficiency, "It requires you to have 100% Efficiency."};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        boolean aWarmedUp;
        boolean bl = aWarmedUp = this.mEfficiency == this.getMaxEfficiency(null);
        if (!aBaseMetaTileEntity.isActive() || !aWarmedUp) {
            if (side == facing) {
                if (aActive) {
                    return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(TAE.GTPP_INDEX(12)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_NUCLEAR_REACTOR_ACTIVE).extFacing().build()};
                }
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(TAE.GTPP_INDEX(12)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_NUCLEAR_REACTOR).extFacing().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(TAE.GTPP_INDEX(12))};
        }
        if (aBaseMetaTileEntity.isActive() && aWarmedUp) {
            if (side == facing) {
                if (aActive) {
                    return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(TAE.GTPP_INDEX(13)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_NUCLEAR_REACTOR_ACTIVE).extFacing().build()};
                }
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(TAE.GTPP_INDEX(13)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_NUCLEAR_REACTOR).extFacing().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(TAE.GTPP_INDEX(13))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(TAE.GTPP_INDEX(12))};
    }

    public final boolean addNuclearReactorEdgeList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        MTEHatchOutput hatch;
        MTEHatchInput hatch2;
        MTEHatchDynamo dynamo;
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchMaintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof MTEHatchDynamo && (dynamo = (MTEHatchDynamo)aMetaTileEntity).getTierForStructure() >= 4 && dynamo.getTierForStructure() <= 6) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof MTEHatchInput && (hatch2 = (MTEHatchInput)aMetaTileEntity).getTierForStructure() >= 5) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof MTEHatchOutput && (hatch = (MTEHatchOutput)aMetaTileEntity).getTierForStructure() >= 5) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public final boolean addNuclearReactorTopList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        MTEHatchMuffler hatch;
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchMuffler && (hatch = (MTEHatchMuffler)aMetaTileEntity).getTierForStructure() >= 5) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    @Override
    public IStructureDefinition<MTENuclearReactor> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCCCCCC", "COOOOOC", "COXXXOC", "COXXXOC", "COXXXOC", "COOOOOC", "CCCCCCC"}, {"GGGGGGG", "G-----G", "G-----G", "G-----G", "G-----G", "G-----G", "GGGGGGG"}, {"GGGGGGG", "G-----G", "G-----G", "G-----G", "G-----G", "G-----G", "GGGGGGG"}, {"CCC~CCC", "COOOOOC", "COOOOOC", "COOOOOC", "COOOOOC", "COOOOOC", "CCCCCCC"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTENuclearReactor.class).atLeast(HatchElement.Maintenance).casingIndex(TAE.GTPP_INDEX(12)).dot(1).build(), GTStructureUtility.buildHatchAdder(MTENuclearReactor.class).atLeast(HatchElement.InputHatch, HatchElement.OutputHatch).adder(MTENuclearReactor::addNuclearReactorEdgeList).hatchItemFilterAnd(t -> GTStructureUtility.filterByMTETier(5, Integer.MAX_VALUE)).casingIndex(TAE.GTPP_INDEX(12)).dot(1).build(), GTStructureUtility.buildHatchAdder(MTENuclearReactor.class).atLeast(HatchElement.Dynamo).adder(MTENuclearReactor::addNuclearReactorEdgeList).hatchItemFilterAnd(t -> GTStructureUtility.filterByMTETier(4, 6)).casingIndex(TAE.GTPP_INDEX(12)).dot(1).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)12))})).addElement('X', GTStructureUtility.buildHatchAdder(MTENuclearReactor.class).atLeast(HatchElement.Muffler).adder(MTENuclearReactor::addNuclearReactorTopList).hatchItemFilterAnd(t -> GTStructureUtility.filterByMTETier(5, Integer.MAX_VALUE)).casingIndex(TAE.GTPP_INDEX(12)).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)12)))).addElement('O', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)12)).addElement('G', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)13)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 3, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 3, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        if (this.checkPiece(this.mName, 3, 3, 0) && this.mCasing >= 27 && (this.mOutputHatches.size() >= 3 || this.canDumpFluidToME()) && !this.mInputHatches.isEmpty() && this.mDynamoHatches.size() == 4 && this.mMufflerHatches.size() == 4) {
            this.turnCasingActive(false);
            return true;
        }
        return false;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return 4000;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTENuclearReactor(this.mName);
    }

    public boolean turnCasingActive(boolean status) {
        if (this.mDynamoHatches != null) {
            for (MTEHatch hatch : this.mDynamoHatches) {
                hatch.updateTexture(status ? TAE.GTPP_INDEX(13) : TAE.GTPP_INDEX(12));
            }
        }
        if (this.mMufflerHatches != null) {
            for (MTEHatch hatch : this.mMufflerHatches) {
                hatch.updateTexture(status ? TAE.GTPP_INDEX(13) : TAE.GTPP_INDEX(12));
            }
        }
        if (this.mOutputHatches != null) {
            for (MTEHatch hatch : this.mOutputHatches) {
                hatch.updateTexture(status ? TAE.GTPP_INDEX(13) : TAE.GTPP_INDEX(12));
            }
        }
        if (this.mInputHatches != null) {
            for (MTEHatch hatch : this.mInputHatches) {
                hatch.updateTexture(status ? TAE.GTPP_INDEX(13) : TAE.GTPP_INDEX(12));
            }
        }
        if (this.mMaintenanceHatches != null) {
            for (MTEHatch hatch : this.mMaintenanceHatches) {
                hatch.updateTexture(status ? TAE.GTPP_INDEX(13) : TAE.GTPP_INDEX(12));
            }
        }
        return true;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return OverclockCalculator.ofNoOverclock((long)recipe.getMetadataOrDefault(GTRecipeConstants.LFTR_OUTPUT_POWER, 0).intValue() * 4L, recipe.mDuration);
            }

            @Override
            @NotNull
            public CheckRecipeResult process() {
                CheckRecipeResult result = super.process();
                if (!result.wasSuccessful()) {
                    MTENuclearReactor.this.resetMultiProcessing();
                }
                return result;
            }

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                MTENuclearReactor.this.mFuelRemaining = 0;
                int li2bef4 = 0;
                FluidStack aFuelFluid = null;
                for (FluidStack aFluidInput : recipe.mFluidInputs) {
                    if (aFluidInput.getFluid().equals(MaterialsNuclides.Li2BeF4.getFluid())) continue;
                    aFuelFluid = aFluidInput;
                    break;
                }
                if (aFuelFluid != null) {
                    for (FluidStack fluidStack : this.inputFluids) {
                        if (fluidStack.isFluidEqual(aFuelFluid)) {
                            MTENuclearReactor.this.mFuelRemaining += fluidStack.amount;
                            continue;
                        }
                        if (!fluidStack.getFluid().equals(MaterialsNuclides.Li2BeF4.getFluid())) continue;
                        li2bef4 += fluidStack.amount;
                    }
                }
                if (MTENuclearReactor.this.mFuelRemaining < 100) {
                    return CheckRecipeResultRegistry.NO_FUEL_FOUND;
                }
                if (li2bef4 < 200) {
                    return SimpleCheckRecipeResult.ofFailure("no_li2bef4");
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
        };
    }

    protected void resetMultiProcessing() {
        this.mEfficiency = 0;
        this.mLastRecipe = null;
        this.stopMachine(ShutDownReasonRegistry.NONE);
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        if (this.mEfficiency < this.getMaxEfficiency(null)) {
            this.mMaxProgresstime = 1;
            this.mEfficiencyIncrease = 2;
            this.lEUt = 0L;
            return SimpleCheckRecipeResult.ofSuccess("warm_up");
        }
        CheckRecipeResult result = super.checkProcessing();
        if (result.wasSuccessful() && this.lEUt < 0L) {
            this.lEUt = -this.lEUt;
        }
        return result;
    }

    @Override
    public void explodeMultiblock() {
        long explodevalue;
        this.mInventory[1] = null;
        for (MetaTileEntity tTileEntity : this.mInputBusses) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        for (MetaTileEntity tTileEntity : this.mOutputBusses) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        for (MetaTileEntity tTileEntity : this.mInputHatches) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        for (MetaTileEntity tTileEntity : this.mOutputHatches) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        for (MetaTileEntity tTileEntity : this.mDynamoHatches) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        for (MetaTileEntity tTileEntity : this.mMufflerHatches) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        for (MetaTileEntity tTileEntity : this.mEnergyHatches) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        for (MetaTileEntity tTileEntity : this.mMaintenanceHatches) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
        this.getBaseMetaTileEntity().doExplosion(explodevalue);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.getWorld().field_72995_K) {
            if (aBaseMetaTileEntity.isActive()) {
                this.turnCasingActive(this.mEfficiency == this.getMaxEfficiency(null));
            } else {
                this.turnCasingActive(false);
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEfficiency == this.getMaxEfficiency(null) && MathUtils.randInt(1, 300) == 1) {
            this.addOutput(MaterialsElements.getInstance().URANIUM233.getFluidStack(MathUtils.randInt(1, 10)));
        }
        return super.onRunningTick(aStack);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mFuelRemaining", this.mFuelRemaining);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mFuelRemaining = aNBT.func_74762_e("mFuelRemaining");
        super.loadNBTData(aNBT);
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }
}

